<?php
   /*
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatorePaginaProfilo extends VisualizzatoreComponente {
        private $datiUtente;
        
        function __construct($db) {
            parent::__construct($db);
        }
        
        function creaSezione($dati) {
            $idSezione = "";
            $classeSezione = "";
            if($dati["idSezione"]!="") {
                $idSezione = "id=\"{$dati["idSezione"]}\"";
            } 
            if($dati["classeSezione"]!="") {
                $classeSezione = "class=\"{$dati["classeSezione"]}\"";
            }
            $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "" : "container";
            echo"<section  $idSezione $classeSezione >
                    <div class=\"$classeContainer\">
                        <div class=\"row\">";
                            $this->generaContenutoSezione($dati);
                    echo"</div>
                    </div>
                </section>";
        }
        
        function generaContenutoSezione($dati) {
            ?>
            <div class="col-12">
                <?php 
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==100) {
                                echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Dati profilo modificati
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>";
                            }
                            if($_GET["status"]==200) {
                                echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Password modificata
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>";
                            }
                            else if($_GET["status"]==444) {
                                echo"<p class=\"alert alert-danger\">Password non modificata, digita correttamente la vecchia password</p>";
                            }
                        }
                ?>

                <ul class="nav nav-tabs" id="myTab" role="tablist">
                      <li class="nav-item" role="presentation">
                            <a class="nav-link active" id="home-tab" data-toggle="tab" href="#datiRegistrazione" role="tab" aria-controls="home" aria-selected="true">Dati registrazione</a>
                      </li>
                      <li class="nav-item" role="presentation">
                            <a class="nav-link" id="home-tab" data-toggle="tab" href="#foto" role="tab" aria-controls="home" aria-selected="true">Foto</a>
                      </li>
                      <li class="nav-item" role="presentation">
                            <a class="nav-link" id="profile-tab" data-toggle="tab" href="#password" role="tab" aria-controls="profile" aria-selected="false">Password</a>
                      </li>
                      <li class="nav-item" role="presentation">
                            <a class="nav-link" id="profile-tab" data-toggle="tab" href="#datiPersonali" role="tab" aria-controls="profile" aria-selected="false">Dati personali</a>
                      </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                      <div id="datiRegistrazione" role="tabpanel" aria-labelledby="home-tab" class="tab-pane fade show active mt-3" >
                            <form name="datiProfilo" action="utenti/modificaProfilo.php" method="post" enctype="multipart/form-data">
                                <!-- Colonna dati testuali -->
                                <div class="form-row">
                                    <div class="col-sm-6 form-group">
                                        <label for="email_address">Nome *</label>
                                       <input type="text" name="nome" class="form-control" value="<?php echo($this->datiUtente['nome']); ?>" required>
                                    </div>
                                    <div class="col-sm-6 form-group">
                                        <label for="email_address">Cognome *</label>
                                       <input type="text" id="cognome" name="cognome" class="form-control"  value="<?php echo($this->datiUtente['cognome']); ?>" required >
                                    </div>
                                    <div class="col-sm-6 form-group">
                                        <label for="email_address">Email *</label>
                                        <input type="email" name="email" class="form-control"  value="<?php echo($this->datiUtente['email']); ?>" required="">
                                    </div>
                                    <div class="col-sm-6 form-group">
                                        <label for="telefono">Telefono</label>
                                       <input type="text" id="telefono" name="telefono" class="form-control" value="<?php echo($this->datiUtente['telefono']); ?>">
                                    </div>                                    
                                    <div class="col-sm-12 form-group">
                                        <label for="via">Via</label>
                                                <input type="text" id="via" name="via" class="form-control" value="<?php echo($this->datiUtente['via']); ?>">
                                    </div>

                                    <div class="col-sm-6 form-group">
                                        <label for="citta">Città</label>
                                       <input type="text" id="citta" name="citta" class="form-control" value="<?php echo($this->datiUtente['citta']); ?>">
                                    </div>

                                    <div class="col-sm-6 form-group">
                                        <label for="cap">Cap</label>
                                        <input type="text" id="cap" name="cap" class="form-control" value="<?php echo($this->datiUtente['cap']); ?>">
                                    </div>

                                    <div class="col-sm-12 form-group">
                                        <label for="organizzazione">Organizzazione</label>
                                        <input type="text" id="organizzazione" name="organizzazione" class="form-control" value="<?php echo($this->datiUtente['organizzazione']); ?>">
                                    </div>

                                    <div class="col-sm-6 form-group">
                                        <label for="codiceFiscale">Codice Fiscale</label>
                                        <input type="text" id="codiceFiscale" name="codiceFiscale" class="form-control" value="<?php echo($this->datiUtente['codiceFiscale']); ?>">
                                    </div>

                                    <div class="col-sm-6 form-group">
                                        <label for="partitaIva">Partita IVA</label>
                                        <input type="text" id="partitaIva" name="partitaIva" class="form-control" value="<?php echo($this->datiUtente['partitaIva']); ?>">
                                    </div>

                                    <div class="col-sm-6 form-group">
                                        <label for="pec">PEC</label>
                                        <input type="text" id="pec" name="pec" class="form-control" value="<?php echo($this->datiUtente['pec']); ?>">
                                    </div>

                                    <div class="col-sm-6 form-group">
                                        <label for="codiceInterscambio">Codice interscambio</label>
                                        <input type="text" id="codiceInterscambio" name="codiceInterscambio" class="form-control" value="<?php echo($this->datiUtente['codiceInterscambio']); ?>">
                                    </div>
                                </div>
                                <div class="text-right mt-3">
                                    <button type="submit" class="btn btn-primary" onclick="document.datiProfilo.submit()"><i class="fas fa-check mr-1"></i>Salva</button>
                                </div>
                            </form>  
                      </div>
                      <div id="foto" role="tabpanel" aria-labelledby="home-tab" class="tab-pane fade show mt-3" >
                          <div class="row">
                            <div class="col-lg-6">
                                <div class="img-container">
                                    <div class="azioni mr-4 mt-4">
                                        <div class="btn-group" role="group" aria-label="">
                                            <button onclick="eliminaFotoProfilo()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                        </div>
                                    </div>
                                    <img class="img-fluid bg-light p-3 mb-3" id="fotoUtente" src="<?php echo(($this->datiUtente['foto']!="") ? $this->datiUtente['foto'] : "immagini/altro/segnaPostoUtente.png"); ?>" >
                                </div>
                            </div>

                            <div class="col-lg-6">
                                <form action="utenti/cambiaImmaginiUtente.php" id="frmFotoProfilo" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                    <div class="dz-message">
                                        <i class="fas fa-file-upload fa-2x mb-2"></i>
                                        <h5>Trascina o carica qui l'immagine</h5>
                                    </div>
                                    <div class="fallback">
                                        <input name="file" type="file" />
                                    </div>
                                </form>
                            </div>
                        </div>
                      </div>
                      <div id="password" role="tabpanel" aria-labelledby="home-tab" class="tab-pane fade show mt-3" >
                             <form name="formCambiaPassword" action="utenti/cambiaPassword.php" method="post">
                                <div class="form-row">
                                    <div class="col-md-7 col-lg-4 form-group">
                                        <label for="password">Password Attuale</label>
                                        <input type="password" id="passwordAttuale" name="passwordAttuale" class="form-control" placeholder="Inserisci la password">
                                    </div>
                                       <div class="col-md-7 col-lg-4 form-group">
                                        <label for="password">Nuova Password</label>
                                       <input type="password" id="password" name="password" class="form-control" placeholder="Inserisci la nuova password">
                                    </div>
                                    <div class="col-md-7 col-lg-4 form-group">
                                        <label for="password">Ripeti Password</label>
                                        <input type="password" id="confermaPassword" class="form-control" placeholder="Ripeti la password">
                                    </div>
                                </div>
                                <div class="text-right mt-3">
                                    <button type="button" class="btn btn-primary " onclick="validazionePassword()"><i class="fas fa-check mr-1"></i>Salva</button>
                                </div>
                             </form>
                      </div>
                      <div id="datiPersonali" role="tabpanel" aria-labelledby="home-tab" class="tab-pane fade show mt-3" >
                            <p>Clicca sul pulsante qui sotto per sapere quali sono i tuoi dati presenti su questa piattaforma </p>

                            <div class="text-right mt-3">
                                <button type="button" class="btn btn-primary " onclick="{location.href='utenti/scaricaDatiPersonali.php';}"><i class="fas fa-download mr-1"></i>Scarica i tuoi dati</button>
                            </div>
                      </div>
                </div>
            </div>
            <?php
        }
        
        public function getJavascriptAssociato() {
            return "<script type=\"text/javascript\" src=\"plugins/password-strength-meter-1.1.0/dist/password.min.js\"></script>
                    <script type=\"text/javascript\">
                        jQuery(document).ready(function($) {
                            $('#password').password({
                              shortPass: '<span class=\"pwd-corta\">La password è troppo corta, usa una password <strong>FORTE</strong> per scongiurare attacchi al tuo sito</span>',
                              badPass: '<span class=\"pwd-insufficiente\">Insufficiente. Prova a combinare lettere e numeri</span>',
                              goodPass: '<span class=\"pwd-media\">Media, aggiungi un carattere speciale per renderla più sicura</span>',
                              strongPass: '<span class=\"pwd-forte\">Password forte</span>',
                              containsUsername: '<span class=\"pwd-corta\">La tua password contiene lo username! Per motivi di sicurezza è bene sia diversa</span>',
                              enterPass: '',
                              showPercent: false,
                              animate: false,
                              minimumLength: 6,
                            });
                        });
                    </script>";
        }
        
        // getter & setter
        public function getUtente() {
            return $this->datiUtente;
        }

        public function setDatiUtente($datiUtente) {
            $this->datiUtente = $datiUtente;
        }

    }